#include "StdAfx.h"
#include "SpeedDome.h"
#include "ControlDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//################################################################
// LED()
//#################################################################

void CControlDlg::LED(CString data)
{   
CClientDC	dc( GetDlgItem(IDC_DOMEID_LED) );	// dc is radar-frame in dialog box
CBrush		m_brush;							// Handle of null brush
BITMAP		m_bmInfo;							// Bitmap information structure 
CPoint		m_pt;								// Position for upper left corner 
CSize		m_size;								// Size (width and height) of bitmap
CRect		rectClient;							// radar-frame size
CBitmap*	LEDBmap;
CDC			m_dcMem;									// Compatible memory DC for Radar show   
														// 1. draw in memory 
														// 2. paste to frame 
														// 3. Avoid Screen gilttering

LEDBmap=&(m_LEDBmap);									//-- get LED bitmap retrived from OnInitDialog
m_brush.CreateStockObject(NULL_BRUSH);					//Load null brush 
LEDBmap->GetObject(sizeof(BITMAP),&m_bmInfo);
//-- Get frame coordinate -- Zero based coordinate ----
GetDlgItem(IDC_DOMEID_LED)->GetClientRect(&rectClient);	
	m_size.cx=rectClient.right;		m_pt.y=rectClient.top;
	m_pt.x=rectClient.left;			m_size.cy=rectClient.bottom;
	
VERIFY(m_dcMem.CreateCompatibleDC(&dc));				//---- Create memory DC using the LED-frame
m_dcMem.SelectObject(LEDBmap);							//---- load LED-frame's bitmap to memory
//---
CRect	rect;							// for radar pciture frame
CPen*   pen;    //for change different color pen and brush
CBrush* brush;    

GetDlgItem(IDC_DOMEID_LED)->GetClientRect(rect);
pen=new CPen(PS_SOLID,2,RGB(61,61,61)); 
brush=new CBrush(RGB(61,61,61)); 
	CBrush* oldBrush=m_dcMem.SelectObject(brush);
	CPen*   oldPen = m_dcMem.SelectObject(pen);
	m_dcMem.SelectObject(brush);
	m_dcMem.SelectObject(pen);
	m_dcMem.Rectangle(&rect);	//cover(dark-circle) the previous radar 
	m_dcMem.SelectObject(oldPen);
	m_dcMem.SelectObject(oldBrush);
delete pen;
delete brush;
//--- Draw LED to memory ---
CFont   fontText;										// change the default font 
fontText.CreateFont(12,0,0,0,400,FALSE,FALSE,0,
                   ANSI_CHARSET,OUT_TT_PRECIS,
                   CLIP_DEFAULT_PRECIS,PROOF_QUALITY,
				   DEFAULT_PITCH|FF_SWISS,"Arial");
CFont* pOldFont  =( CFont*) m_dcMem.SelectObject(&fontText);
 
//-----------------------------------------------------------------
m_dcMem.SetBkColor(RGB(30,100,155));
m_dcMem.SetTextColor(RGB(104,210,255));
m_dcMem.TextOut(5,2,data);

m_dcMem.SelectObject(pOldFont);
//---------- Paste radar picture form memory to radar-frame -------
dc.BitBlt(m_pt.x ,m_pt.y ,m_size.cx ,m_size.cy ,
		  &m_dcMem,0,0,SRCCOPY);

DeleteDC(m_dcMem);
}








